/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.suncode.plugin.dataviewer.configuration.Configuration;
import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.transfer.ConfigurationDataViewerRootDto;
import com.suncode.plugin.dataviewer.transfer.ConfigurationMenuConverter;
import com.suncode.plugin.dataviewer.transfer.ConfigurationMenuDto;
import com.suncode.plugin.dataviewer.transfer.ConfigurationTransferElement;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.pwfl.configuration.audit.ConfigurationTransferAudit;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConfigurationImporter {
    private final Plugin plugin;
    private final ConfigurationService configurationService;
    private final ConfigurationMenuConverter configurationMenuConverter;

    @Transactional
    public void importConfig(PluginConfigurationDtoRoot pluginConfiguration, ConfigurationTransferAudit importAudit) throws IOException {
        if (!this.plugin.getKey().equals(pluginConfiguration.getPluginId())) {
            throw new PluginsException("The configuration object is not the " + this.plugin.getName() + " plugin configuration");
        }
        ConfigurationDataViewerRootDto config = (ConfigurationDataViewerRootDto)pluginConfiguration;
        if (!config.getMetadata().isSelected()) {
            return;
        }
        Configuration existingConfiguration = this.configurationService.getConfiguration();
        List<ConfigurationMenuDto> menusToImport = config.getMenus().getList().stream().filter(menu -> menu.getMetadata().isSelected()).toList();
        this.updateMenusInExistingConfiguration(existingConfiguration, menusToImport);
        this.configurationService.save(existingConfiguration);
        importAudit.addElement("DATA VIEWER " + ConfigurationTransferElement.CONFIG);
    }

    private void updateMenusInExistingConfiguration(Configuration existingConfiguration, List<ConfigurationMenuDto> menusToImport) throws JsonProcessingException {
        List<Menu> existingMenus = existingConfiguration.getMenus();
        List<Menu> menusToUpdate = this.configurationMenuConverter.convertToMenu(menusToImport);
        Map<String, Menu> menuMap = existingMenus.stream().collect(Collectors.toMap(Menu::getId, menu -> menu));
        for (Menu menuToUpdate : menusToUpdate) {
            if (menuMap.containsKey(menuToUpdate.getId())) {
                int index = existingMenus.indexOf(menuMap.get(menuToUpdate.getId()));
                existingMenus.set(index, menuToUpdate);
                continue;
            }
            existingMenus.add(menuToUpdate);
        }
    }

    public ConfigurationImporter(Plugin plugin, ConfigurationService configurationService, ConfigurationMenuConverter configurationMenuConverter) {
        this.plugin = plugin;
        this.configurationService = configurationService;
        this.configurationMenuConverter = configurationMenuConverter;
    }
}

