/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.comment;

import com.suncode.plugin.dataviewer.service.comment.Comment;
import com.suncode.plugin.dataviewer.service.comment.CommentKey;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CommentService {
    @Autowired
    private SessionFactory sessionFactory;

    public Comment getComment(Long id) {
        return (Comment)this.sessionFactory.getCurrentSession().get(Comment.class, (Serializable)id);
    }

    public void addComment(Comment comment) {
        CommentKey key = this.getCommentKey(comment.getKey());
        if (key == null) {
            Long id = (Long)this.sessionFactory.getCurrentSession().save((Object)comment.getKey());
            key = (CommentKey)this.sessionFactory.getCurrentSession().get(CommentKey.class, (Serializable)id);
        }
        comment.setKey(key);
        comment.setDate(new Date().getTime());
        this.sessionFactory.getCurrentSession().save((Object)comment);
    }

    public void changeComment(Comment comment) {
        Comment entity = this.getComment(comment.getId());
        if (entity != null) {
            entity.apply(comment);
            this.sessionFactory.getCurrentSession().update((Object)entity);
        }
    }

    public void deleteComment(Comment comment) {
        if (comment != null) {
            this.sessionFactory.getCurrentSession().delete((Object)comment);
        }
    }

    private CommentKey getCommentKey(CommentKey example) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CommentKey.class);
        criteria.add((Criterion)Example.create((Object)example));
        return (CommentKey)criteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).uniqueResult();
    }

    public List<Comment> getComments(String menuId, String viewId, DataSupplierFactory.DataSupplierType supplierType, String supplierId) {
        List<CommentKey> keys = this.getCommentKeys(menuId, viewId, supplierType, supplierId);
        if (CollectionUtils.isEmpty(keys)) {
            return new ArrayList<Comment>();
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(Comment.class);
        criteria.createAlias("key", "key");
        criteria.add(Restrictions.in((String)"key.id", (Collection)keys.stream().map(CommentKey::getId).collect(Collectors.toList())));
        return criteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }

    private List<CommentKey> getCommentKeys(String menuId, String viewId, DataSupplierFactory.DataSupplierType supplierType, String supplierId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CommentKey.class);
        criteria.add((Criterion)Example.create((Object)CommentKey.viewExample(menuId, viewId, supplierType, supplierId)));
        return criteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).list();
    }
}

