/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.persmission;

import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.configuration.Permissions;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.persmission.MenuUserPair;
import com.suncode.plugin.dataviewer.service.persmission.PermissionCache;
import com.suncode.plugin.dataviewer.service.persmission.PermissionException;
import com.suncode.plugin.dataviewer.service.persmission.UserContext;
import com.suncode.plugin.framework.support.Condition;
import com.suncode.plugin.framework.support.ConditionSupport;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PermissionService {
    private static final Logger log = LoggerFactory.getLogger(PermissionService.class);
    @Autowired
    private UserService userService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private PermissionCache permissionCache;

    public void validatePermission(String menuId) {
        if (!this.hasPermissionToMenu(menuId)) {
            throw new PermissionException();
        }
    }

    public boolean hasPermissionToMenu(String menuId) {
        return this.createCondition(menuId).isFulfilled();
    }

    public Condition createCondition(final String menuId) {
        return new ConditionSupport(){

            public boolean isFulfilled() {
                String userName = UserContext.userName();
                try {
                    MenuUserPair key = MenuUserPair.builder().menuId(menuId).username(userName).build();
                    Optional<Boolean> optionalBoolean = PermissionService.this.permissionCache.get(key);
                    if (optionalBoolean.isPresent()) {
                        return optionalBoolean.get();
                    }
                    return PermissionService.this.isFullfilled(key);
                }
                catch (Exception ex) {
                    log.error("Error while checking permissions for menu " + menuId + "  for user " + userName, (Throwable)ex);
                    return false;
                }
            }
        };
    }

    private Boolean isFullfilled(MenuUserPair pair) {
        List<String> groupNames;
        Menu menu = this.getMenu(pair);
        Permissions permissions = menu.getPermissions();
        List<String> usernames = permissions.getUsers();
        Optional<Boolean> optionalValue = this.checkCachable(pair, usernames, groupNames = permissions.getGroups());
        if (optionalValue.isPresent()) {
            Boolean value = optionalValue.get();
            this.permissionCache.put(pair, value);
            return value;
        }
        Boolean weakValue = this.checkWeakCachable(pair, groupNames);
        this.permissionCache.putTemporarily(pair, weakValue);
        return weakValue;
    }

    private Optional<Boolean> checkCachable(MenuUserPair pair, List<String> usernames, List<String> groupNames) {
        if (usernames.isEmpty() && groupNames.isEmpty()) {
            return Optional.of(false);
        }
        boolean usernameMatches = usernames.stream().anyMatch(username -> username.equals(pair.getUsername()));
        if (usernameMatches) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private Boolean checkWeakCachable(MenuUserPair pair, List<String> groupNames) {
        PlatformTransactionManager manager = TransactionManagerFactory.getHibernateTransactionManager();
        return (Boolean)new TransactionTemplate(manager).execute(status -> {
            User user = this.userService.getUser(pair.getUsername(), new String[]{"groups"});
            return user.getGroups().stream().anyMatch(group -> groupNames.stream().anyMatch(permissionGroupName -> permissionGroupName.equals(group.getName())));
        });
    }

    private Menu getMenu(MenuUserPair pair) {
        return this.configurationService.getConfiguration().getMenus().stream().filter(menuItem -> menuItem.getId().equals(pair.getMenuId())).findFirst().orElseThrow(IllegalArgumentException::new);
    }
}

