/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.suncode.plugin.dataviewer.configuration.Configuration;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationCache;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationLoadingException;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.web.WebFragmentsManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    public static final String FILENAME = "config.json";
    private final ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
    @Autowired
    private WebFragmentsManager webFragmentsManager;
    @Autowired
    private ConfigurationCache configurationCache;
    @Autowired
    private PluginStore store;

    @PostConstruct
    private void init() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Configuration getConfiguration() {
        try {
            String configurationJson = this.configurationCache.get();
            if (StringUtils.isBlank((String)configurationJson)) {
                configurationJson = "{}";
            }
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (Configuration)this.mapper.readValue(configurationJson, Configuration.class);
        }
        catch (Exception ex) {
            throw new ConfigurationLoadingException(ex);
        }
    }

    public void save(Configuration configuration) throws IOException {
        String json = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)configuration);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));){
            this.store.store(FILENAME, (InputStream)stream, true);
            this.configurationCache.invalidate();
            this.refreshMenus();
        }
    }

    private void refreshMenus() {
        this.webFragmentsManager.refreshInterface();
    }
}

