import Assert from '../../assert/Assert';

export const OPEN_URL = 'openUrl';

class OpenUrlActionResolver {
  getAction(rawAction) {
    let url = rawAction.url;
    Assert.hasText(url, 'Url cannot be empty');

    return {
      type: rawAction.type,
      url: url,
      absolute: !!rawAction.absolute,
      openInNewTab: !!rawAction.openInNewTab,
      parameters: this.getParameters(rawAction),
    };
  }

  getParameters(rawAction) {
    return rawAction.parameters.map(parameter => {
      let name = parameter.name;
      Assert.hasText(name, 'Parameter name cannot be empty');

      let value = parameter.value;
      let outputId = parameter.outputId;
      Assert.hasText(value + outputId, 'Value or OutputId for parameter name ' + name + ' cannot be empty');

      return {
        name,
        value,
        outputId,
      };
    });
  }

  validate(action, view) {
    action.parameters.forEach(parameter => {
      if (parameter.outputId) {
        let outputId = parameter.outputId;
        let mappingOutput = view.outputs.find(output => output.id == outputId);
        Assert.notNull(mappingOutput, 'In view ' + view.id + ' there is no output with id ' + outputId);
      }
    });
  }
}

export default new OpenUrlActionResolver();
