import ShowViewActionResolver, { SHOW_VIEW } from './ShowViewActionResolver';
import Assert from '../../assert/Assert';
import ShowActivityFormActionResolver, { SHOW_ACTIVITY_FORM } from './ShowActivityFormActionResolver';
import ShowActivityDetailsActionResolver, { SHOW_ACTIVITY_DETAILS } from './ShowActivityDetailsActionResolver';
import ShowProcessDetailsActionResolver, { SHOW_PROCESS_DETAILS } from './ShowProcessDetailsActionResolver';
import ShowCommentsWindowActionResolver, { SHOW_COMMENTS } from './ShowCommentsWindowActionResolver';
import OpenUrlActionResolver, { OPEN_URL } from './OpenUrlActionResolver';

class ActionResolver {
  getAction(obj) {
    let action = obj.action;
    if (action) {
      let type = action.type;
      Assert.hasText(type, 'Action type is not defined');

      switch (type) {
        case SHOW_VIEW:
          return ShowViewActionResolver.getAction(action);
        case SHOW_ACTIVITY_FORM:
          return ShowActivityFormActionResolver.getAction(action);
        case SHOW_ACTIVITY_DETAILS:
          return ShowActivityDetailsActionResolver.getAction(action);
        case SHOW_PROCESS_DETAILS:
          return ShowProcessDetailsActionResolver.getAction(action);
        case SHOW_COMMENTS:
          return ShowCommentsWindowActionResolver.getAction(action);
        case OPEN_URL:
          return OpenUrlActionResolver.getAction(action);
        default:
          throw 'Unknown action type ' + type;
      }
    } else {
      return null;
    }
  }

  getMiddleClickAction(obj) {
    let action = obj.middleClickAction;
    if (action) {
      let type = action.type;
      Assert.hasText(type, 'Action type is not defined');

      switch (type) {
        case SHOW_ACTIVITY_FORM:
          return ShowActivityFormActionResolver.getAction(action);
        case SHOW_ACTIVITY_DETAILS:
          return ShowActivityDetailsActionResolver.getAction(action);
        case SHOW_PROCESS_DETAILS:
          return ShowProcessDetailsActionResolver.getAction(action);
        case OPEN_URL:
          return OpenUrlActionResolver.getAction(action);
        default:
          throw 'Unsupported type for middle click action: ' + type;
      }
    } else {
      return null;
    }
  }

  validate(views) {
    views.forEach(view => {
      let viewAction = view.action;
      let actions = view.outputs.filter(output => output.action).map(output => output.action);

      if (viewAction) {
        Assert.isEmpty(actions, 'There is action already defined on whole view ' + view.id);
        this.validateActions([viewAction], view, views);
      } else {
        this.validateActions(actions, view, views);
      }

      let linkActions = view.links.flatMap(link => link.action);
      this.validateActions(linkActions, view, views);
    });
  }

  validateActions(actions, view, views) {
    actions.forEach(action => {
      let type = action.type;
      switch (type) {
        case SHOW_VIEW:
          ShowViewActionResolver.validate(action, view, views);
          break;
        case SHOW_ACTIVITY_FORM:
          ShowActivityFormActionResolver.validate(action, view);
          break;
        case SHOW_ACTIVITY_DETAILS:
          ShowActivityDetailsActionResolver.validate(action, view);
          break;
        case SHOW_PROCESS_DETAILS:
          ShowProcessDetailsActionResolver.validate(action, view);
          break;
        case OPEN_URL:
          OpenUrlActionResolver.validate(action, view);
          break;
        case SHOW_COMMENTS:
          break;
        default:
          throw 'Unknown action type ' + type;
      }
    });
  }
}

export default new ActionResolver();
