import ActionResolver from './action/ActionResolver';
import Assert from '../assert/Assert';
import OutputFormatResolver from './OutputFormatResolver';
import StyleResolver from './StyleResolver';
import ConditionResolver from './ConditionResolver';

class OutputResolver {
  getOutputs(view) {
    Assert.notEmpty(view.outputs, 'Outputs are empty');

    let outputs = view.outputs.map(output => {
      Assert.hasText(output.id, 'Output id cannot be empty');
      Assert.hasText(output.name, 'Output name cannot be empty');
      Assert.hasText(output.alias, 'Output alias cannot be empty');

      return {
        id: output.id,
        name: output.name,
        alias: output.alias,
        hidden: !!output.hidden,
        action: ActionResolver.getAction(output),
        actionCondition: ConditionResolver.getCondition(output.actionCondition),
        primaryKey: !!output.primaryKey,
        format: OutputFormatResolver.getFormat(output),
        styles: StyleResolver.getStyles(output),
        noWrap: output.noWrap,
      };
    });

    this.validateOutputs(outputs);
    return outputs;
  }

  validateOutputs(outputs) {
    this.validateUniqueIds(outputs);
    this.validateSinglePrimaryKey(outputs);
  }

  validateUniqueIds(outputs) {
    Assert.areUnique(
      outputs.map(output => output.id),
      'Output ids are not unique'
    );
  }

  validateSinglePrimaryKey(outputs) {
    let primaryKeyOutputs = outputs.filter(output => output.primaryKey);

    Assert.notEmpty(primaryKeyOutputs, 'Primary key output has te be specified');
    Assert.isTrue(primaryKeyOutputs.length == 1, 'There are more than 1 primary key output');
  }
}

export default new OutputResolver();
