import { distinct } from '../../util/arrayUtils';

class Assert {
  hasText(text, error) {
    this.isTrue(text && text.trim(), error);
  }

  notNull(obj, error) {
    this.isTrue(obj != null, error);
  }

  isEmpty(array, error) {
    this.isTrue(array && array.length == 0, error);
  }

  notEmpty(array, error) {
    this.isTrue(array && array.length > 0, error);
  }

  isTrue(condition, error) {
    if (!condition) {
      throw error;
    }
  }

  areUnique(array, error) {
    let distinctArray = distinct(array);
    this.isTrue(distinctArray.length == array.length, error);
  }
}

export default new Assert();
