/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.util;

import java.util.function.Supplier;

public class LazyCache<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private volatile Supplier<T> cache;

    public LazyCache(Supplier<T> supplier) {
        this.supplier = supplier;
        this.reset();
    }

    private void reset() {
        this.cache = new MemoizingSupplier<T>(this.supplier);
    }

    @Override
    public T get() {
        return this.cache.get();
    }

    public void invalidate() {
        this.reset();
    }

    private static class MemoizingSupplier<T>
    implements Supplier<T> {
        final Supplier<T> delegate;
        volatile T value;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.value == null) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (this.value == null) {
                        this.value = this.delegate.get();
                    }
                }
            }
            return this.value;
        }
    }
}

