/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.dataviewer.configuration.Configuration;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.transfer.ConfigurationDataViewerRootDto;
import com.suncode.plugin.dataviewer.transfer.ConfigurationTransferElement;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.pwfl.configuration.audit.ConfigurationTransferAudit;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import java.io.IOException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConfigurationImporter {
    private final Plugin plugin;
    private final ConfigurationService configurationService;

    @Transactional
    public void importConfig(PluginConfigurationDtoRoot pluginConfiguration, ConfigurationTransferAudit importAudit) throws IOException {
        if (!this.plugin.getKey().equals(pluginConfiguration.getPluginId())) {
            throw new PluginsException("The configuration object is not the " + this.plugin.getName() + " plugin configuration");
        }
        ConfigurationDataViewerRootDto config = (ConfigurationDataViewerRootDto)pluginConfiguration;
        if (!config.getMetadata().isSelected()) {
            return;
        }
        Configuration configuration = (Configuration)new ObjectMapper().readValue(config.getConfiguration(), Configuration.class);
        this.configurationService.save(configuration);
        importAudit.addElement("DATA VIEWER " + ConfigurationTransferElement.CONFIG);
    }

    public ConfigurationImporter(Plugin plugin, ConfigurationService configurationService) {
        this.plugin = plugin;
        this.configurationService = configurationService;
    }
}

