/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.favourites;

import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.favourites.DataViewerFavouriteRenderer;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.pwfl.favourites.FavouriteElement;
import com.suncode.pwfl.favourites.FavouriteHandler;
import com.suncode.pwfl.favourites.view.Definition;
import com.suncode.pwfl.favourites.view.FavouritesRenderer;
import com.suncode.pwfl.favourites.view.NestedDefinition;
import com.suncode.pwfl.favourites.view.Parameter;
import com.suncode.pwfl.favourites.view.support.TileDto;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DataViewerFavouritesHandler
implements FavouriteHandler {
    private static final String PARENT_TYPE = "data-viewer";
    private static final String TYPE = "data-viewer-menu";
    public static final int ORDER = 1000;
    private final Translator translator = Translators.get(DataViewerFavouritesHandler.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private PermissionService permissionService;

    public boolean supports(String type) {
        return TYPE.equals(type);
    }

    public Collection<Definition> getDefinitions() {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        definitions.add(this.getParentDefinition());
        definitions.addAll(this.getNestedDefinitions());
        return definitions;
    }

    private Definition getParentDefinition() {
        Definition parentDefinition = new Definition(PARENT_TYPE, 1000);
        parentDefinition.setName(this.translator.getMessage("data.viewer.favourites.parent.name"));
        parentDefinition.setDisplayName(this.translator.getMessage("data.viewer.favourites.parent.name"));
        parentDefinition.setCountable(false);
        parentDefinition.setSupported(false);
        return parentDefinition;
    }

    private List<NestedDefinition> getNestedDefinitions() {
        return this.getMenusAvailableToUser().stream().map(menu -> {
            NestedDefinition definition = new NestedDefinition(PARENT_TYPE, TYPE);
            definition.setName(menu.getName());
            definition.setDisplayName(menu.getName());
            definition.setDescription(this.translator.getMessage("data.viewer.favouriotes.child.description", new Object[]{menu.getName()}));
            definition.setTypeDescription(this.translator.getMessage("data.viewer.favouriotes.child.type"));
            definition.setParameter(Parameter.nonRenderable((String)menu.getId()));
            definition.setCountable(false);
            return definition;
        }).toList();
    }

    private List<Menu> getMenusAvailableToUser() {
        return this.configurationService.getConfiguration().getMenus().stream().filter(menu -> this.permissionService.hasPermissionToMenu(menu.getId())).toList();
    }

    public FavouritesRenderer getRenderer(FavouriteElement favourite) {
        DataViewerFavouriteRenderer renderer = (DataViewerFavouriteRenderer)((Object)this.context.getAutowireCapableBeanFactory().createBean(DataViewerFavouriteRenderer.class));
        renderer.setFavourite(favourite);
        return renderer;
    }

    public FavouritesRenderer getTileRenderer(TileDto tileDto) {
        DataViewerFavouriteRenderer renderer = (DataViewerFavouriteRenderer)((Object)this.context.getAutowireCapableBeanFactory().createBean(DataViewerFavouriteRenderer.class));
        renderer.setTileDto(tileDto);
        return renderer;
    }
}

