/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.configuration.format;

import com.suncode.plugin.dataviewer.configuration.format.Format;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleFormat
extends Format {
    private static final Logger log = LoggerFactory.getLogger(DoubleFormat.class);
    public static final String TYPE = "double";
    private Integer decimalPrecision;
    private String thousandSeparator;

    @Override
    public String format(Object value) {
        if (value == null) {
            value = 0L;
        } else if (value instanceof String) {
            value = this.parseValue((String)value);
        }
        try {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
            decimalFormatSymbols.setDecimalSeparator(SystemProperties.getString((String)"DecimalSeparator", (String)".").charAt(0));
            decimalFormatSymbols.setGroupingSeparator(this.thousandSeparator.charAt(0));
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            if (this.getDecimalPrecision() != null) {
                decimalFormat.setMinimumFractionDigits(this.getDecimalPrecision());
                decimalFormat.setMaximumFractionDigits(this.getDecimalPrecision());
            }
            return decimalFormat.format(value);
        }
        catch (Exception e) {
            log.error("Could not format number value {}", value);
            log.error(e.getMessage(), (Throwable)e);
            return value.toString();
        }
    }

    private Object parseValue(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    public Integer getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public String getThousandSeparator() {
        return this.thousandSeparator;
    }

    public void setDecimalPrecision(Integer decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public void setThousandSeparator(String thousandSeparator) {
        this.thousandSeparator = thousandSeparator;
    }

    @Override
    public String toString() {
        return "DoubleFormat(decimalPrecision=" + this.getDecimalPrecision() + ", thousandSeparator=" + this.getThousandSeparator() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleFormat)) {
            return false;
        }
        DoubleFormat other = (DoubleFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$decimalPrecision = this.getDecimalPrecision();
        Integer other$decimalPrecision = other.getDecimalPrecision();
        if (this$decimalPrecision == null ? other$decimalPrecision != null : !((Object)this$decimalPrecision).equals(other$decimalPrecision)) {
            return false;
        }
        String this$thousandSeparator = this.getThousandSeparator();
        String other$thousandSeparator = other.getThousandSeparator();
        return !(this$thousandSeparator == null ? other$thousandSeparator != null : !this$thousandSeparator.equals(other$thousandSeparator));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleFormat;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $decimalPrecision = this.getDecimalPrecision();
        result = result * 59 + ($decimalPrecision == null ? 43 : ((Object)$decimalPrecision).hashCode());
        String $thousandSeparator = this.getThousandSeparator();
        result = result * 59 + ($thousandSeparator == null ? 43 : $thousandSeparator.hashCode());
        return result;
    }
}

