export function showLoading() {
  PW.ui.showLoading();
}

export function hideLoading() {
  PW.ui.hideLoading();
}

export function showSuccess(message) {
  PW.ui.Message.success(message);
}

export function showError(message) {
  PW.ui.Message.error(message);
}

export function showCloseableError(message) {
  PW.ui.Message.error(message, { hideAfter: 0 });
}

export function showWarning(message) {
  PW.ui.Message.warning(message);
}

export function showInfo(message) {
  PW.ui.Message.info(message);
}

export function showMessage(message, messageLevel) {
  let action = MESSAGE_LEVEL[messageLevel];
  if (action) {
    action.call(action, message);
  } else {
    throw new Error('Unsupported message level!');
  }
}

const MESSAGE_LEVEL = Object.freeze({
  success: message => {
    showSuccess(message);
  },
  warn: message => {
    showWarning(message);
  },
  error: message => {
    showError(message);
  },
  info: message => {
    showInfo(message);
  },
});
