import Assert from '../assert/Assert';
import ViewResolver from './ViewResolver';

class MenuResolver {
  async getMenus(configuration) {
    let menus = await Promise.all(
      configuration.menus.map(async menu => {
        Assert.hasText(menu.id, 'Menu id cannot be empty');
        Assert.hasText(menu.name, 'Menu name cannot be empty');

        let views = await ViewResolver.getViews(menu);
        Assert.notEmpty(views, 'Views cannot be empty');

        return {
          id: menu.id,
          name: menu.name,
          views,
        };
      }),
    );

    this.validateMenus(menus);
    this.validateUniqueViewIds(menus);
    return menus;
  }

  validateMenus(menus) {
    this.validateUniqueIds(menus);
  }

  validateUniqueViewIds(menus) {
    let allViewIds = menus.flatMap(menu => menu.views).map(view => view.id);
    Assert.areUnique(allViewIds, 'View id must be unique among all menus');
  }

  validateUniqueIds(menus) {
    Assert.areUnique(
      menus.map(item => item.id),
      'Menu ids are not unique',
    );
  }
}

export default new MenuResolver();
