import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';
import { API_URL } from '../../util/ajaxUtil';

class CommentsService {
  add(commentDetail, viewId, rowId) {
    return axios.post(absolutePath(API_URL + 'comments/' + encodeURIComponent(viewId) + '/' + encodeURIComponent(rowId)), commentDetail);
  }

  delete(commentId) {
    return axios.delete(absolutePath(API_URL + 'comments/' + encodeURIComponent(commentId)));
  }

  change(commentDetail) {
    return axios.put(absolutePath(API_URL + 'comments'), commentDetail);
  }
}

export default new CommentsService();
