/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.web.advice;

import com.suncode.plugin.dataviewer.configuration.ViewNotExistsException;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierNotExistsException;
import com.suncode.plugin.dataviewer.service.persmission.PermissionException;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class DataControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(DataControllerAdvice.class);

    @ResponseBody
    @ExceptionHandler(value={PermissionException.class})
    public ResponseEntity<?> handlePermissionException(Exception ex) {
        return this.exceptionResult(ex, HttpStatus.FORBIDDEN);
    }

    @ResponseBody
    @ExceptionHandler(value={ViewNotExistsException.class})
    public ResponseEntity<?> handleViewNotExists(Exception ex) {
        return this.exceptionResult(ex, HttpStatus.NOT_FOUND);
    }

    @ResponseBody
    @ExceptionHandler(value={DataSupplierNotExistsException.class})
    public ResponseEntity<?> handleDataSupplierNotExists(Exception ex) {
        return this.exceptionResult(ex, HttpStatus.NOT_FOUND);
    }

    private ResponseEntity<?> exceptionResult(Exception ex, HttpStatus status) {
        log.error(ex.getMessage(), (Throwable)ex);
        return this.handleResult(null, ex.getLocalizedMessage(), false, status);
    }

    private ResponseEntity<?> handleResult(CountedResult<Map<String, Object>> data, String message, boolean success, HttpStatus status) {
        EntityRestResult result = new EntityRestResult();
        result.setSuccess(success);
        result.setMessage(message);
        result.setEntity(data);
        return new ResponseEntity((Object)result, (HttpStatusCode)status);
    }
}

