/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.dataviewer.configuration.Output;
import com.suncode.plugin.dataviewer.configuration.Summary;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.configuration.mapping.SummaryOutputMapping;
import com.suncode.plugin.dataviewer.service.export.CellFactory;
import com.suncode.plugin.dataviewer.service.export.ExportRequest;
import com.suncode.plugin.dataviewer.support.TranslatorHolder;
import com.suncode.plugin.dataviewer.web.dto.CommentDto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class ExportService {
    private final ObjectMapper mapper = new ObjectMapper();
    private CellFactory cellFactory;

    public byte[] export(ExportRequest exportRequest) throws IOException {
        try (SXSSFWorkbook workbook = new SXSSFWorkbook();){
            byte[] byArray;
            this.cellFactory = CellFactory.create(workbook);
            this.buildExcel(exportRequest, workbook);
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                workbook.write((OutputStream)stream);
                byArray = stream.toByteArray();
            }
            return byArray;
        }
    }

    private void buildExcel(ExportRequest exportRequest, SXSSFWorkbook workbook) {
        View view = exportRequest.getView();
        SXSSFSheet sheet = workbook.createSheet(view.getName());
        sheet.trackAllColumnsForAutoSizing();
        this.createHeaderCells(view, sheet);
        int lastIndex = this.fillDataRows(exportRequest, sheet);
        this.fillSummaryRows(exportRequest, sheet, lastIndex);
        this.autoSizeColumns(view, sheet);
    }

    private void createHeaderCells(View view, SXSSFSheet sheet) {
        SXSSFRow row = sheet.createRow(0);
        this.cellFactory.createHeaderCell(row, 0, TranslatorHolder.get().getMessage("data.viewer.item"));
        List<Output> outputs = this.getVisibleOutputs(view);
        for (int i = 0; i < outputs.size(); ++i) {
            int columnIndex = i + 1;
            this.cellFactory.createHeaderCell(row, columnIndex, outputs.get(i).getName());
        }
        if (view.isComments()) {
            this.cellFactory.createHeaderCell(row, 1 + outputs.size(), TranslatorHolder.get().getMessage("data.viewer.comments"));
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 1 + outputs.size(), 2 + outputs.size()));
        }
    }

    private int fillDataRows(ExportRequest exportRequest, SXSSFSheet sheet) {
        View view = exportRequest.getView();
        List<Map<String, Object>> dataRows = exportRequest.getData();
        Map<String, List<CommentDto>> commentsMap = exportRequest.getComments();
        int rowIndex = 1;
        List<Output> outputs = this.getVisibleOutputs(view);
        Output primaryKeyOutput = this.getPrimaryKeyOutput(view);
        int commentDateColumnIndex = 1 + outputs.size();
        int commentContentColumnIndex = 2 + outputs.size();
        for (int dataIndex = 0; dataIndex < dataRows.size(); ++dataIndex) {
            SXSSFRow row = sheet.createRow(rowIndex);
            this.cellFactory.createCell(row, (Integer)0, String.valueOf(dataIndex + 1));
            Map<String, Object> dataRow = dataRows.get(dataIndex);
            this.createDataCells(outputs, row, dataRow);
            Object rowIdObject = dataRow.get(primaryKeyOutput.getAlias());
            if (rowIdObject != null) {
                List<CommentDto> comments = commentsMap.get(rowIdObject.toString());
                if (comments != null) {
                    for (CommentDto comment : comments) {
                        SXSSFRow commentRow = sheet.getRow(rowIndex);
                        if (commentRow == null) {
                            commentRow = sheet.createRow(rowIndex);
                        }
                        this.cellFactory.createCell(commentRow, (Integer)commentDateColumnIndex, this.formatCommentDate(new Date(comment.getDate())));
                        this.cellFactory.createCommentContentCell(commentRow, commentContentColumnIndex, comment);
                        ++rowIndex;
                    }
                    if (comments.size() <= 1) continue;
                    this.mergeDataCells(sheet, rowIndex, outputs, comments);
                    continue;
                }
                ++rowIndex;
                continue;
            }
            ++rowIndex;
        }
        return rowIndex;
    }

    private void fillSummaryRows(ExportRequest exportRequest, SXSSFSheet sheet, int lastIndex) {
        View view = exportRequest.getView();
        Summary summary = view.getSummary();
        List<Output> outputs = this.getVisibleOutputs(view);
        int rowIndex = lastIndex;
        for (Map<String, Object> summaryRow : exportRequest.getSummary()) {
            SXSSFRow row = sheet.createRow(rowIndex);
            this.cellFactory.createCell(row, (Integer)0, "");
            HashMap<String, Object> dataRow = new HashMap<String, Object>();
            for (Output output : outputs) {
                Optional<String> optionalAlias = summary.getOutputMappings().stream().filter(mapping -> mapping.getOutputId().equals(output.getId())).map(SummaryOutputMapping::getAlias).findFirst();
                if (optionalAlias.isPresent()) {
                    String alias = optionalAlias.get();
                    dataRow.put(output.getAlias(), summaryRow.getOrDefault(alias, ""));
                    continue;
                }
                dataRow.put(output.getAlias(), "");
            }
            this.createDataCells(outputs, row, dataRow);
            ++rowIndex;
        }
    }

    private void createDataCells(List<Output> outputs, SXSSFRow row, Map<String, Object> dataRow) {
        for (int outputIndex = 0; outputIndex < outputs.size(); ++outputIndex) {
            Output output = outputs.get(outputIndex);
            String alias = output.getAlias();
            Object value = dataRow.get(alias);
            String stringValue = this.formatDataValue(value);
            int columnIndex = outputIndex + 1;
            this.cellFactory.createCellByType(row, columnIndex, value, stringValue, output.getFormat());
        }
    }

    private void mergeDataCells(SXSSFSheet sheet, int rowIndex, List<Output> outputs, List<CommentDto> comments) {
        int bound = outputs.size() + 1;
        for (int columnIndexToMerge = 0; columnIndexToMerge < bound; ++columnIndexToMerge) {
            sheet.addMergedRegion(new CellRangeAddress(rowIndex - comments.size(), rowIndex - 1, columnIndexToMerge, columnIndexToMerge));
        }
    }

    private Output getPrimaryKeyOutput(View view) {
        return view.getOutputs().stream().filter(Output::isPrimaryKey).findFirst().orElseThrow(RuntimeException::new);
    }

    private List<Output> getVisibleOutputs(View view) {
        return view.getOutputs().stream().filter(output -> !output.isHidden()).collect(Collectors.toList());
    }

    private String formatCommentDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    private String formatDataValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            return this.mapper.writeValueAsString(value).replace("\"", "");
        }
        return value.toString();
    }

    private void autoSizeColumns(View view, SXSSFSheet sheet) {
        int columnsCount = 1 + this.getVisibleOutputs(view).size();
        if (view.isComments()) {
            columnsCount += 2;
        }
        IntStream.range(0, columnsCount).forEach(arg_0 -> ((SXSSFSheet)sheet).autoSizeColumn(arg_0));
    }
}

