/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.dataviewer.service.datasupplier;

import com.suncode.plugin.dataviewer.configuration.Output;
import com.suncode.plugin.dataviewer.configuration.SourceData;
import com.suncode.plugin.dataviewer.configuration.Summary;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.configuration.ViewNotExistsException;
import com.suncode.plugin.dataviewer.configuration.format.Format;
import com.suncode.plugin.dataviewer.service.comment.Comment;
import com.suncode.plugin.dataviewer.service.comment.CommentService;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplier;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierFactory;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierNotExistsException;
import com.suncode.plugin.dataviewer.web.dto.CellValueDto;
import com.suncode.plugin.dataviewer.web.dto.CommentDto;
import com.suncode.plugin.dataviewer.web.dto.DataResultDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSupplierService {
    @Autowired
    private DataSupplierFactory dataSupplierFactory;
    @Autowired
    private CommentService commentService;

    public DataResultDto getData(String menuId, View view, Map<String, String> parameters, Pagination pagination, List<Class<? extends Format>> skipFormatting) throws ViewNotExistsException, DataSupplierNotExistsException {
        DataSupplierFactory.DataSupplierType supplierType = view.getSource().getType();
        String supplierId = view.getSource().getId();
        List<Output> outputs = view.getOutputs();
        CountedResult<Map<String, Object>> data = this.getData(supplierType, supplierId, parameters, pagination);
        List<Map<String, CellValueDto>> formattedData = this.formatData(data.getData(), outputs, skipFormatting);
        DataResultDto dataDto = new DataResultDto((CountedResult<Map<String, CellValueDto>>)new CountedResult(data.getTotal(), formattedData));
        if (view.isComments()) {
            dataDto.setComments(this.getComments(menuId, view));
        }
        return dataDto;
    }

    private Map<String, List<CommentDto>> getComments(String menuId, View view) {
        List<Comment> comments = this.commentService.getComments(menuId, view.getId(), view.getSource().getType(), view.getSource().getId());
        return comments.stream().collect(Collectors.groupingBy(comment -> comment.getKey().getRowId(), Collectors.mapping(CommentDto::from, Collectors.toList())));
    }

    public CountedResult<Map<String, Object>> getSummaryData(View view, Map<String, String> parameters, Pagination pagination, List<Class<? extends Format>> skipFormatting) throws ViewNotExistsException, DataSupplierNotExistsException {
        CountedResult<Map<String, Object>> data = this.getFromSource(view.getSummary().getSource(), parameters, pagination);
        this.formatSummaryData(data.getData(), view.getOutputs(), view.getSummary(), skipFormatting);
        return data;
    }

    public CountedResult<Map<String, Object>> getFromSource(SourceData source, Map<String, String> parameters, Pagination pagination) throws ViewNotExistsException, DataSupplierNotExistsException {
        return this.getData(source.getType(), source.getId(), parameters, pagination);
    }

    private CountedResult<Map<String, Object>> getData(DataSupplierFactory.DataSupplierType type, String dataSupplierId, Map<String, String> parameters, Pagination pagination) throws ViewNotExistsException, DataSupplierNotExistsException {
        DataSupplier dataSupplier = this.dataSupplierFactory.getDataSupplier(type, dataSupplierId);
        return dataSupplier.getData(parameters, pagination);
    }

    private List<Map<String, CellValueDto>> formatData(List<Map<String, Object>> data, List<Output> outputs, List<Class<? extends Format>> skipFormatting) {
        Map<String, Output> columnsToFormat = this.filterColumnsWithFormat(outputs).stream().filter(o -> skipFormatting == null || !skipFormatting.contains(o.getFormat().getClass())).collect(Collectors.toMap(Output::getAlias, output -> output));
        return this.formatData(data, columnsToFormat);
    }

    private void formatSummaryData(List<Map<String, Object>> data, List<Output> outputs, Summary summary, List<Class<? extends Format>> skipFormatting) {
        HashMap columnsToFormat = new HashMap();
        List<Output> outputsWithFormat = this.filterColumnsWithFormat(outputs);
        summary.getOutputMappings().forEach(mapping -> outputsWithFormat.stream().filter(output -> output.getId().equals(mapping.getOutputId()) && (skipFormatting == null || !skipFormatting.contains(output.getFormat().getClass()))).findFirst().ifPresent(output -> columnsToFormat.put(mapping.getAlias(), output)));
        if (!columnsToFormat.isEmpty()) {
            data.forEach(row -> columnsToFormat.forEach((id, output) -> row.put(id, output.getFormat().format(row.get(id)))));
        }
    }

    private List<Output> filterColumnsWithFormat(List<Output> outputs) {
        return outputs.stream().filter(output -> output.getFormat() != null).collect(Collectors.toList());
    }

    private List<Map<String, CellValueDto>> formatData(List<Map<String, Object>> data, Map<String, Output> columnsToFormat) {
        return data.stream().map(row -> this.formatMap((Map<String, Object>)row, columnsToFormat)).collect(Collectors.toList());
    }

    private Map<String, CellValueDto> formatMap(Map<String, Object> row, Map<String, Output> columnsToFormat) {
        return row.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Output output = (Output)columnsToFormat.get(entry.getKey());
            String formattedValue = output != null && output.getFormat() != null ? output.getFormat().format(entry.getValue()) : null;
            return new CellValueDto(entry.getValue(), formattedValue);
        }));
    }
}

