export function copy(obj) {
  return JSON.parse(JSON.stringify(obj));
}

export function extend(parent, child) {
  let parentCopy = copy(parent ? parent : {});
  let childCopy = copy(child ? child : {});

  Object.keys(childCopy).forEach(key => {
    parentCopy[key] = childCopy[key];
  });

  return parentCopy;
}
