import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';

class DocumentClassService {
  getDocumentClassesWithRightType(rightType) {
    return axios
      .get(absolutePath(`/api/documents/classes`), {
        params: {
          rightType: rightType,
        },
      })
      .then(response => response.data);
  }

  getDocumentClasses(withAddingRight, start, limit, sortBy, sortDirection) {
    return axios
      .get(absolutePath(`/api/documents/classes/all`), {
        params: {
          withAddingRight: withAddingRight,
          start: start,
          limit: limit,
          sortBy: sortBy,
          sortDirection: sortDirection,
        },
      })
      .then(response => response.data);
  }

  getDocumentClass(docClassId) {
    return axios.get(absolutePath(`/api/documents/classes/${docClassId}`)).then(response => response.data);
  }

  getExpirationTypes() {
    return axios.get(absolutePath(`/api/documents/expirationTypes`)).then(response => response.data);
  }

  getCipherAlgorithms() {
    return axios.get(absolutePath(`/api/documents/cipherAlgorithms`)).then(response => response.data);
  }

  createDocumentClass(documentClass) {
    return axios
      .post(absolutePath('/api/documents/classes/'), documentClass)
      .then(response => response)
      .catch(error => error.response);
  }

  updateDocumentClass(docClassId, documentClass) {
    return axios
      .patch(absolutePath(`/api/documents/classes/${docClassId}`), documentClass)
      .then(response => response)
      .catch(error => error.response);
  }

  deleteDocumentClass(docClassId) {
    return axios
      .delete(absolutePath(`/api/documents/classes/${docClassId}`))
      .then(response => response)
      .catch(error => error.response);
  }

  moveUpDocumentClass(docClassId) {
    return axios
      .get(absolutePath(`/api/documents/classes/${docClassId}/moveUp`))
      .then(response => response)
      .catch(error => error.response);
  }

  export(extension, sortBy, sortDirection) {
    const paramsQuery = jQuery.param({
      sortBy,
      sortDirection,
    });
    window.location.href = absolutePath(`api/documents/classes/export/${extension}?${paramsQuery}`);
  }
}

export default new DocumentClassService();
