import { defineStore } from 'pinia';

export const stickyFilterStore = defineStore('stickyFilter', {
  state: () => ({
    filters: [],
  }),

  actions: {
    saveFilter(filter) {
      const filterToSave = {
        id: filter.id,
        value: filter.value,
        viewIds: filter.stickyViewIds,
      };

      const existingIndex = this.filters.findIndex(f => f.id === filter.id);
      if (existingIndex !== -1) {
        this.filters[existingIndex] = filterToSave;
      } else {
        this.filters.push(filterToSave);
      }
    },

    getFiltersForView(viewId) {
      return this.filters.filter(filter => filter.viewIds.some(id => id === viewId));
    },
  },
});
