import Assert from '../assert/Assert';
import ActionResolver from './action/ActionResolver';
import ConditionResolver from './ConditionResolver';

class LinkResolver {
  getLinks(view) {
    if (view.links) {
      let links = view.links.map(link => {
        Assert.hasText(link.id, 'Link id cannot be empty');
        Assert.hasText(link.name, 'Link name cannot be empty');
        Assert.notNull(link.action, 'Link action cannot be empty');

        return {
          id: link.id,
          name: link.name,
          action: ActionResolver.getAction(link),
          showCondition: ConditionResolver.getCondition(link.showCondition),
          show: true,
        };
      });

      this.validateLinks(links);
      return links;
    } else {
      return [];
    }
  }

  validateLinks(links) {
    this.validateUniqueIds(links);
  }

  validateUniqueIds(links) {
    Assert.areUnique(
      links.map(link => link.id),
      'Link ids are not unique',
    );
  }
}

export default new LinkResolver();
