import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';
import { API_URL } from '../../util/ajaxUtil';

class ResultsService {
  getResults(view, start, limit, sortByAliasId, asc, parameters) {
    let direction = asc == true || asc == null ? 'ASC' : 'DESC';
    let property = sortByAliasId;

    return axios
      .get(absolutePath(API_URL + 'data/' + encodeURIComponent(view.id)), {
        params: { start, limit, direction, property, parameters },
      })
      .then(result => {
        let entity = result.data.entity;

        let results = entity.data.map(row =>
          Object.keys(row).map(key => {
            let value = row[key].value;
            let formattedValue = row[key].formattedValue;
            return {
              alias: key,
              value,
              formattedValue,
            };
          }),
        );

        let comments = entity.comments;
        let commentDetails = Object.keys(comments).map(key => {
          let rowComments = comments[key];
          rowComments.sort((item1, item2) => item1.date - item2.date);

          return {
            rowId: key,
            comments: rowComments,
          };
        });

        return {
          results,
          count: entity.total,
          commentDetails,
        };
      });
  }
}

export default new ResultsService();
