import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';
import { API_URL } from '../../util/ajaxUtil';

class ListDataService {
  getListData(viewId, input, query) {
    return axios
      .get(absolutePath(API_URL + 'data/' + encodeURIComponent(viewId) + '/' + encodeURIComponent(input.id) + '/list'), {
        params: { query },
      })
      .then(result => {
        let entity = result.data.entity;
        let data = entity.data;
        return data.map(row =>
          Object.keys(row).map(key => ({
            alias: key,
            value: row[key] + '',
          })),
        );
      });
  }
}

export default new ListDataService();
