import axios from 'axios';
import { absolutePath } from '../../util/urlUtils';
import { API_URL } from '../../util/ajaxUtil';

class DefaultValueDataService {
  async getDefaultValue(view, input) {
    const viewId = view.id;
    const inputId = input.id;

    return axios
      .get(absolutePath(`${API_URL}data/${encodeURIComponent(viewId)}/${encodeURIComponent(inputId)}/defaultValue`))
      .then(result => {
        return result.data;
      });
  }
}

export default new DefaultValueDataService();
