package com.suncode.plugin.dataviewer.web.view;

import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.plugin.dataviewer.service.persmission.UserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import com.suncode.pwfl.administration.user.UserSettingsService;

import jakarta.servlet.http.HttpServletRequest;

@Controller
public class ViewController
{
    private static final String CONFIGURATION_VIEW = "config";

    private static final String MENU_VIEW = "menu";

    @Autowired
    private PermissionService permissionService;

    @Autowired
    private UserSettingsService userSettingsService;

    @RequestMapping( "/{menuId}/viewer" )
    public String menu( @PathVariable( "menuId" ) String menuId, HttpServletRequest request )
    {
        permissionService.validatePermission( menuId );

        request.setAttribute( "menuId", menuId );
        request.setAttribute( "lang", LocaleContextHolder.getLocale().getLanguage() );
        request.setAttribute( "userPageSize", userSettingsService.getUserPageSize( UserContext.userName() ) );
        return MENU_VIEW;
    }

    @RequestMapping( "/configure" )
    public String configuration()
    {
        return CONFIGURATION_VIEW;
    }
}
