package com.suncode.plugin.dataviewer.web.gadget;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.favourites.util.SessionUtils;
import jakarta.servlet.http.HttpServletRequest;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Optional;

@Controller
@RequestMapping( "/gadget" )
@RequiredArgsConstructor
public class GadgetController
{
    private static final String GADGET_VIEW = "gadget";

    private static final String GADGET_ATTRIBUTE_NAME = "gadget";

    private final UserSettingsService userSettingsService;

    private final ObjectMapper objectMapper = new ObjectMapper();

    @GetMapping( "data-viewer" )
    public String dataViewer( Model model, HttpServletRequest request )
        throws JsonProcessingException
    {
        String gadgetJson = (String) request.getAttribute( GADGET_ATTRIBUTE_NAME );
        DataViewerGadget dataViewerGadget = objectMapper.readValue( gadgetJson, DataViewerGadget.class );

        String menuId = Optional.ofNullable( dataViewerGadget.getProperties().get( DataViewerGadget.MENU_ID_PROPERTY ).getValue() ).orElse(
            StringUtils.EMPTY );
        int pageSize = Integer.parseInt( dataViewerGadget.getProperties().get( DataViewerGadget.PAGE_SIZE_PROPERTY ).getValue() );

        String username = SessionUtils.getCurrentUserName();
        model.addAttribute( "skinPath", getSkinPath( username ) );
        model.addAttribute( "lang", LocaleContextHolder.getLocale().getLanguage() );
        model.addAttribute( "gadgetPageSize", pageSize );
        model.addAttribute( "menuId", menuId );

        return GADGET_VIEW;
    }

    private String getSkinPath( String username )
    {
        return userSettingsService.getSkinForUser( username ).getPath();
    }
}
