package com.suncode.plugin.dataviewer.web.dto;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.ServiceFactory;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Data
@NoArgsConstructor
public class UserDto
{
    private String userName;

    private String firstName;

    private String lastName;

    private String email;

    private String number;

    private static LoadingCache<String, UserDto> loadingCache = CacheBuilder.newBuilder()
                    .refreshAfterWrite( 10, TimeUnit.SECONDS )
                    .maximumSize( 100 ).build(
                                    new CacheLoader<String, UserDto>()
                                    {
                                        @Override
                                        public UserDto load( String userId )
                                                        throws Exception
                                        {
                                            UserService userService = ServiceFactory.getUserService();
                                            User user = userService.getUser( userId );

                                            if ( user != null )
                                            {
                                                return new UserDto( user );
                                            }
                                            return null;
                                        }
                                    }
                    );

    private UserDto( User user )
    {
        userName = user.getUserName();
        firstName = user.getFirstName();
        lastName = user.getLastName();
        email = user.getEmail();
        number = user.getNumber();
    }

    public static UserDto get( String userId )
    {
        if ( StringUtils.isBlank( userId ) )
        {
            return null;
        }

        try
        {
            return loadingCache.get( userId );
        }
        catch ( ExecutionException e )
        {
            return null;
        }
    }
}
