package com.suncode.plugin.dataviewer.util;

import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.util.SpringContext;
import jakarta.activation.DataHandler;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.UnsupportedEncodingException;

@Slf4j
public class MailUtils
{

    public static void send( String recipients, String subject, String reportFilename,
                             String content, byte[] byteArray )
        throws MessagingException, UnsupportedEncodingException
    {
        EmailService emailService = SpringContext.getBean( EmailService.class );
        EmailConfigurationService emailConfigurationService = SpringContext.getBean( EmailConfigurationService.class );

        EmailConfiguration emailConfiguration = emailConfigurationService.getDefaultConfiguration();
        Session session = emailService.getSession( emailConfiguration );

        MimeMessage message = new MimeMessage( session );
        message.addRecipients( Message.RecipientType.BCC, recipients );
        message.setSubject( subject );
        message.setFrom( getInternetAddress( emailConfiguration.getEmail(), emailConfiguration.getSourceAddress() ) );

        Multipart multipart = new MimeMultipart();
        BodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent( content, "text/html; charset=utf-8" );
        multipart.addBodyPart( messageBodyPart );

        messageBodyPart = new MimeBodyPart();
        String mimeType = "application/vnd.ms-excel ";
        messageBodyPart.setDataHandler( new DataHandler( new ByteArrayDataSource( byteArray, mimeType ) ) );
        messageBodyPart.setFileName( MimeUtility.encodeText( reportFilename, "UTF-8", null ) );
        multipart.addBodyPart( messageBodyPart );

        message.setContent( multipart );
        emailService.send( message );
        log.debug( "An email with report generated from scheduled task has been sent to the addresses: " + recipients );
    }

    private static InternetAddress getInternetAddress( String email, String sourceAddress )
        throws AddressException
    {
        if ( StringUtils.isBlank( sourceAddress ) )
        {
            return new InternetAddress( email );
        }
        else
        {
            try
            {
                return new InternetAddress( email, sourceAddress );
            }
            catch ( UnsupportedEncodingException e )
            {
                log.error( e.getMessage() );
                return new InternetAddress( email );
            }
        }
    }
}
