package com.suncode.plugin.dataviewer.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@RequiredArgsConstructor
public class ConfigurationExporter
{
    private final Plugin plugin;

    private final ConfigurationService configurationService;

    private final ConfigurationMenuConverter configurationMenuConverter;

    public PluginConfigurationDtoRoot exportConfig()
        throws JsonProcessingException
    {
        List<Menu> menus = configurationService.getMenusAvailableForUser();
        return new ConfigurationDataViewerRootDto( plugin.getKey(), plugin.getName(),
                                                   configurationMenuConverter.convertToDto( menus ) );
    }
}
