package com.suncode.plugin.dataviewer.service.persmission;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.springframework.stereotype.Service;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Service
public class PermissionCache
{
    private static final Long EXPIRATION_TIME_SEC = 60L;

    private Cache<MenuUserPair, Boolean> permanentCache = CacheBuilder.newBuilder()
                    .build();

    private Cache<MenuUserPair, Boolean> expirationCache = CacheBuilder.newBuilder()
                    .expireAfterWrite( EXPIRATION_TIME_SEC, TimeUnit.SECONDS )
                    .build();

    public Optional<Boolean> get( MenuUserPair key )
    {
        synchronized ( this )
        {
            Boolean permanentValue = permanentCache.getIfPresent( key );
            if ( permanentValue != null )
            {
                return Optional.of( permanentValue );
            }
            else
            {
                return Optional.ofNullable( expirationCache.getIfPresent( key ) );
            }
        }
    }

    public void put( MenuUserPair key, Boolean value )
    {
        synchronized ( this )
        {
            permanentCache.put( key, value );
        }
    }

    public void putTemporarily( MenuUserPair key, Boolean value )
    {
        synchronized ( this )
        {
            expirationCache.put( key, value );
        }
    }

    public void invalidate()
    {
        synchronized ( this )
        {
            permanentCache.invalidateAll();
            expirationCache.invalidateAll();
        }
    }
}
