package com.suncode.plugin.dataviewer.service.datasupplier;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.suncode.pwfl.datasource.DataSourceService;

@Component
public class DataSupplierFactory
{
    @Autowired
    private DataSourceService dataSourceService;
    
    public enum DataSupplierType
    {
        DATASOURCE
    }
    
    public DataSupplier getDataSupplier( DataSupplierType type, String id )
    {
        switch( type )
        {
            case DATASOURCE:
            {
                return new DataSourceSupplier( id, dataSourceService );
            }
            default:
            {
                throw new IllegalArgumentException( "Unknow data supplier type [" + type.toString() + "]" );
            }
        }
    }
}
