package com.suncode.plugin.dataviewer.service.datasupplier;

import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@AllArgsConstructor
public class DataSourceSupplier
                implements DataSupplier
{
    private String id;

    private DataSourceService dataSourceService;

    @Override
    public CountedResult<Map<String, Object>> getData( Map<String, String> parameters, Pagination pagination )
                    throws DataSupplierNotExistsException
    {
        DataSourceInstance dataSource = dataSourceService.getDataSource( id );
        ensureDataSource( dataSource );

        return dataSource.execute( parameters, pagination );
    }

    private void ensureDataSource( DataSourceInstance dataSource )
                    throws DataSupplierNotExistsException
    {
        if ( dataSource == null )
        {
            throw new DataSupplierNotExistsException( id );
        }
    }

    @Override
    public Map<String, String> getAliasTypes()
    {
        DataSourceInstance dataSource = dataSourceService.getDataSource( id );
        if ( dataSource == null )
        {
            throw new IllegalArgumentException( "Data supplier with id " + id + " does not exist" );
        }

        return dataSource.getInputParameters().stream()
                        .map( dataSourceParameter -> new AbstractMap.SimpleEntry<>( dataSourceParameter.getId(), dataSourceParameter.getType() ) )
                        .collect( Collectors.toMap( Map.Entry::getKey, Map.Entry::getValue ) );
    }
}
