package com.suncode.plugin.dataviewer.service.configuration;

import com.suncode.plugin.dataviewer.service.persmission.PermissionCache;
import com.suncode.plugin.dataviewer.util.LazyCache;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;

@Slf4j
@Service
public class ConfigurationCache
{
    private LazyCache<String> configurationJsonCache = new LazyCache<>( this::loadConfigurationString );

    @Autowired
    private PermissionCache permissionCache;

    @Autowired
    private PluginStore store;

    @SneakyThrows
    private String loadConfigurationString()
    {
        PluginStoreResource resource = store.read( ConfigurationService.FILENAME );
        if ( resource != null )
        {
            try (InputStream stream = resource.getInputStream())
            {
                return IOUtils.toString( stream, StandardCharsets.UTF_8 );
            }
        }
        else
        {
            log.warn( "Configuration file does not exists" );
            return StringUtils.EMPTY;
        }
    }

    public String get()
    {
        return configurationJsonCache.get();
    }

    public void invalidate()
    {
        configurationJsonCache.invalidate();
        permissionCache.invalidate();
    }
}
