package com.suncode.plugin.dataviewer.service.comment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierFactory.DataSupplierType;

@Service
@Transactional
public class CommentService
{
    @Autowired
    private SessionFactory sessionFactory;
    
    public Comment getComment( Long id )
    {
        return (Comment) sessionFactory.getCurrentSession().get( Comment.class, id );
    }
    
    public void addComment( Comment comment )
    {
        CommentKey key = getCommentKey( comment.getKey() );
        if( key == null )
        {
            Long id = (Long) sessionFactory.getCurrentSession().save( comment.getKey() );
            key = (CommentKey) sessionFactory.getCurrentSession().get( CommentKey.class, id );
        }
        comment.setKey( key );
        comment.setDate( ( new Date() ).getTime() );
        sessionFactory.getCurrentSession().save( comment );
    }
    
    public void changeComment( Comment comment )
    {
        Comment entity = getComment( comment.getId() );
        if( entity != null )
        {
            entity.apply( comment );
            sessionFactory.getCurrentSession().update( entity );
        }
    }
    
    public void deleteComment( Comment comment )
    {
        if( comment != null )
        {
            sessionFactory.getCurrentSession().delete( comment );
        }
    }
    
    private CommentKey getCommentKey( CommentKey example )
    {
        DetachedCriteria criteria = DetachedCriteria.forClass( CommentKey.class );
        criteria.add( Example.create( example ) );
        return (CommentKey) criteria.getExecutableCriteria( sessionFactory.getCurrentSession() ).uniqueResult();
    }
    
    @SuppressWarnings( "unchecked" )
    public List<Comment> getComments( String menuId, String viewId, DataSupplierType supplierType, String supplierId )
    {
        List<CommentKey> keys = getCommentKeys( menuId, viewId, supplierType, supplierId );
        if( CollectionUtils.isEmpty( keys ) )
        {
            return new ArrayList<>();
        }
        DetachedCriteria criteria = DetachedCriteria.forClass( Comment.class );
        criteria.createAlias( "key", "key" );
        criteria.add( Restrictions.in( "key.id", keys.stream().map( CommentKey::getId ).collect( Collectors.toList() ) ) );
        return (List<Comment>) criteria.getExecutableCriteria( sessionFactory.getCurrentSession() ).list();
    }
    
    @SuppressWarnings( "unchecked" )
    private List<CommentKey> getCommentKeys( String menuId, String viewId, DataSupplierType supplierType, String supplierId )
    {
        DetachedCriteria criteria = DetachedCriteria.forClass( CommentKey.class );
        criteria.add( Example.create( CommentKey.viewExample( menuId, viewId, supplierType, supplierId ) ) );
        return (List<CommentKey>) criteria.getExecutableCriteria( sessionFactory.getCurrentSession() ).list();
    }
}
