package com.suncode.plugin.dataviewer.service.comment;

import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierFactory.DataSupplierType;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import lombok.Data;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

@Data
@RequiredArgsConstructor
@Entity
@Table(
    name = "dv_comment_key",
    uniqueConstraints = @UniqueConstraint( columnNames = { "menuId",
                                                           "viewId",
                                                           "supplierType",
                                                           "supplierId",
                                                           "row_id" }, name = "dv_comment_key_uk" ) )
@SequenceGenerator( name = "dv_comment_key_seq", sequenceName = "dv_comment_key_id" )

@Embeddable
public class CommentKey
{
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "dv_comment_key_seq")
    private Long id;

    @NonNull
    private String menuId;

    @NonNull
    private String viewId;

    @NonNull
    @Enumerated
    private DataSupplierType supplierType;

    @NonNull
    private String supplierId;

    @NonNull
    @Column(name = "row_id")
    private String rowId;

    @SuppressWarnings( "unused" )
    private CommentKey(){}

    private CommentKey( String menuId, String viewId, DataSupplierType supplierType, String supplierId )
    {
        this.menuId = menuId;
        this.viewId = viewId;
        this.supplierType = supplierType;
        this.supplierId = supplierId;
    }

    protected static CommentKey viewExample( String menuId, String viewId, DataSupplierType supplierType, String supplierId )
    {
        return new CommentKey( menuId, viewId, supplierType, supplierId );
    }
}
