package com.suncode.plugin.dataviewer.service.comment;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "dv_comments")
@SequenceGenerator(name = "dv_comments_seq", sequenceName = "dv_comments_id")
public class Comment
{
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "dv_comments_seq")
    private Long id;
    
    @ManyToOne
    @JoinColumn( name = "comment_key", nullable = false )
    private CommentKey key;
    
    private String content;
    
    private String author;
    
    private Boolean bold;
    
    private Boolean italic;
    
    private Boolean underline;
    
    private String color;

    @Column(name = "comment_date")
    private Long date;
    
    public void apply( Comment comment )
    {
        this.content = comment.getContent();
        this.bold = comment.getBold();
        this.italic = comment.getItalic();
        this.underline = comment.getUnderline();
        this.color = comment.getColor();
    }
}
