package com.suncode.plugin.dataviewer.menu;

import com.suncode.plugin.framework.support.LocalizedMessage;
import org.springframework.context.support.StaticMessageSource;

public class SimpleLocalizedMessage
                extends LocalizedMessage
{
    private String message;

    private SimpleLocalizedMessage( String message )
    {
        super( new StaticMessageSource(), message );
        this.message = message;
    }

    public static SimpleLocalizedMessage of( String message )
    {
        return new SimpleLocalizedMessage( message );
    }

    @Override public String getMessage()
    {
        return message;
    }

    @Override public String getRequiredMessage()
    {
        return message;
    }
}
