package com.suncode.plugin.dataviewer.menu;

import java.util.List;

import com.suncode.pwfl.web.ui.DivanteIcon;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.web.support.MenuBuilder;
import com.suncode.plugin.framework.web.support.MenuEntry;

public class DataViewerMenuBuilder
        implements MenuBuilder
{
    private static Integer ORDER = Ordered.LOWEST_PRECEDENCE;

    private static String SECTION = "system.menu.top";

    @Autowired
    private Plugin plugin;

    @Autowired
    private MenuResolver menuResolver;

    @Override
    public void menu( String keyPrefix, Builder builder )
    {
        List<DataViewerMenu> menus = menuResolver.resolveMenus( plugin.getKey() );
        menus.forEach( menu -> builder.section( SECTION )
                .addItem( new MenuEntry( menu.getId(), menu.getLink(),
                        menu.getLabel(), ORDER, menu.getConditions(),
                        DivanteIcon.LIST.getCode() ) ) );
    }
}
