package com.suncode.plugin.dataviewer.favourites;

import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.favourites.view.support.FavouritesRendererSupport;
import com.suncode.pwfl.web.ui.DivanteIcon;
import org.springframework.beans.factory.annotation.Autowired;

public class DataViewerFavouriteRenderer
    extends FavouritesRendererSupport
{
    private static final String DATA_VIEWER_URL_PATTERN = "plugin/%s/%s/viewer";

    @Autowired
    private Plugin plugin;

    @Autowired
    private PermissionService permissionService;

    @Override
    public boolean shouldRender()
    {
        return permissionService.hasPermissionToMenu( getFavourite().getParameter() );
    }

    @Override
    public boolean shouldTileGadgetRender()
    {
        return permissionService.hasPermissionToMenu( getTileDto().getParameter() );
    }

    @Override
    public String renderType()
    {
        return getMessageSource().getMessage( "data.viewer.favourites.child.type" );
    }

    @Override
    public String renderTileGadgetType()
    {
        return renderType();
    }

    @Override
    public String renderDescription()
    {
        return getMessageSource().getMessage( "data.viewer.favourites.child.description" );
    }

    @Override
    public String renderTileGadgetDescription()
    {
        return renderDescription();
    }

    @Override
    public String renderIcon()
    {
        return DivanteIcon.LIST.getCode();
    }

    @Override
    public String renderTileGadgetIcon()
    {
        return renderIcon();
    }

    @Override
    public String renderTileColor()
    {
        return null;
    }

    @Override
    public String renderTileGadgetColor()
    {
        return null;
    }

    @Override
    public String renderAction()
    {
        return getAnchor( url( getFavourite().getParameter() ), getMessageSource().getMessage( "data.viewer.favourites.enter" ),
                          getFavourite().isNewWindow() );
    }

    @Override
    public String renderTileGadgetAction()
    {
        return getAnchor( url( getTileDto().getParameter() ), getMessageSource().getMessage( "data.viewer.favourites.enter" ),
                          getTileDto().getNewWindow() );
    }

    private String url( String menuId )
    {
        return DATA_VIEWER_URL_PATTERN.formatted( plugin.getKey(), menuId );
    }
}