package com.suncode.plugin.dataviewer.configuration.format;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Data
@EqualsAndHashCode( callSuper = true )
public class TimestampFormat
    extends Format
{
    public static final String TYPE = "timestamp";

    private String dateFormat = "yyyy-MM-dd hh:mm:ss";

    public String format( Object value )
    {
        if ( value == null )
        {
            return "";
        }
        if ( value instanceof String )
        {
            return value.toString();
        }
        try
        {
            return new SimpleDateFormat( dateFormat ).format( (Timestamp) value );
        }
        catch ( Exception e )
        {
            log.error( "Could not format timestamp value {}", value );
            log.error( e.getMessage(), e );
            return value.toString();
        }
    }
}
