package com.suncode.plugin.dataviewer.configuration.format;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import lombok.Data;

@Data
@JsonTypeInfo( use = JsonTypeInfo.Id.NAME, property = "type", visible = true )
@JsonSubTypes( {
                @JsonSubTypes.Type( value = IntegerFormat.class, name = IntegerFormat.TYPE ),
                @JsonSubTypes.Type( value = DoubleFormat.class, name = DoubleFormat.TYPE ),
                @JsonSubTypes.Type( value = TimestampFormat.class, name = TimestampFormat.TYPE )
} )
public abstract class Format
{
    @JsonIgnore
    private String type;

    public abstract String format( Object value );
}
