package com.suncode.plugin.dataviewer.configuration.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

import com.suncode.pwfl.administration.configuration.SystemProperties;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Data
@EqualsAndHashCode( callSuper = true )
public class DoubleFormat
    extends Format
{
    public static final String TYPE = "double";

    private Integer decimalPrecision;

    private String thousandSeparator;
    
    public String format( Object value )
    {
        if( value == null )
        {
            value = 0L;
        }
        else if( value instanceof String )
        {
            value = parseValue( (String) value );
        }
        try
        {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
            decimalFormatSymbols.setDecimalSeparator( SystemProperties.getString( "DecimalSeparator", "." ).charAt( 0 ) );
            decimalFormatSymbols.setGroupingSeparator( thousandSeparator.charAt( 0 ) );

            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols( decimalFormatSymbols );
            decimalFormat.setRoundingMode( RoundingMode.HALF_UP );
            if( getDecimalPrecision() != null )
            {
                decimalFormat.setMinimumFractionDigits( getDecimalPrecision() );
                decimalFormat.setMaximumFractionDigits( getDecimalPrecision() );
            }
            return decimalFormat.format( value );
        }
        catch( Exception e )
        {
            log.error( "Could not format number value {}", value );
            log.error( e.getMessage(), e );
            return value.toString();
        }
    }

    private Object parseValue( String value )
    {
        try
        {
            return new BigDecimal( value );
        }
        catch( Exception e )
        {
            return value;
        }
    }

}
