package com.suncode.plugin.dataviewer.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.plugin.dataviewer.configuration.action.Action;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.LinkedList;
import java.util.List;

@Data
@EqualsAndHashCode( of = { "id" } )
public class View
{
    private String id;

    private String name;

    @JsonProperty( "default" )
    private boolean primary;

    private SourceData source;

    private boolean comments;

    private Summary summary;

    private Action action;

    private Condition actionCondition;

    private Action middleClickAction;

    private Condition middleClickActionCondition;

    private Long pageSize;

    private List<Input> inputs = new LinkedList<>();

    private List<Output> outputs = new LinkedList<>();

    private List<Link> links = new LinkedList<>();

    private boolean searchOnLoad = true;

    private boolean hideFiltersOnLoad;

    private DocumentExtras documentExtras;

    private List<String> disabledViewIds = new LinkedList<>();

    private String nameTemplate;

    private boolean disableSorting;
}
