package com.suncode.plugin.dataviewer.configuration;

import lombok.Data;

import java.util.LinkedList;
import java.util.List;

@Data
public class Input
{
    public static final InputType DEFAULT_INPUT_TYPE = InputType.STRING;

    private String id;

    private String name;

    private String alias;

    private InputType type;

    private SourceData source;

    private String defaultValue;

    private SourceData dynamicDefaultValue;

    private String dateFormat;

    private DateReturnType returnType;

    private Boolean showTime;

    private List<String> stickyViewIds = new LinkedList<>();

    private boolean allowMultipleValues;
}
