package com.suncode.plugin.dataviewer.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

public enum DateReturnType
{
    TIMESTAMP, STRING;

    @JsonCreator
    public static DateReturnType forValue( String value )
    {
        return Stream.of( values() )
            .filter( type -> type.value().equals( value ) )
            .findFirst()
            .orElseThrow( RuntimeException::new );
    }

    @JsonValue
    public String value()
    {
        return name().toLowerCase();
    }
}
