package com.suncode.plugin.dataviewer.web.dto;

import com.suncode.plugin.dataviewer.service.comment.Comment;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class CommentDto
{
    private Long id;

    private Boolean bold;

    private Boolean italic;

    private Boolean underline;

    private String color;

    private String content;

    private UserDto author;

    private Long date;
    
    public static CommentDto from( Comment comment )
    {
        return CommentDto.builder()
                        .id( comment.getId() )
                        .content( comment.getContent() )
                        .author( UserDto.get( comment.getAuthor() ) )
                        .date( comment.getDate() )
                        .bold( comment.getBold() )
                        .italic( comment.getItalic() )
                        .underline( comment.getUnderline() )
                        .color( comment.getColor() )
                        .build();
        
    }
    
    public Comment buildDomain()
    {
        return Comment.builder()
                        .id( id )
                        .content( content )
                        .author( author.getUserName() )
                        .bold( bold )
                        .italic( italic )
                        .underline( underline )
                        .color( color )
                        .build();
    }
}
