package com.suncode.plugin.dataviewer.web.api;

import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.configuration.View;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.plugin.dataviewer.web.dto.MenuDto;
import com.suncode.plugin.dataviewer.web.dto.MenuViewDto;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping( "api/menu" )
@RequiredArgsConstructor
public class MenuController
{
    private final ConfigurationService configurationService;

    private final PermissionService permissionService;

    @GetMapping
    public List<MenuDto> getMenus()
    {
        return configurationService.getConfiguration()
            .getMenus()
            .stream()
            .filter( menu -> permissionService.hasPermissionToMenu( menu.getId() ) )
            .map( this::toMenuDto )
            .toList();
    }

    private MenuDto toMenuDto( Menu menu )
    {
        var views = menu.getViews().stream()
            .map( this::toMenuViewDto )
            .toList();
        return new MenuDto( menu.getId(), menu.getName(), views );
    }

    private MenuViewDto toMenuViewDto( View view )
    {
        return new MenuViewDto( view.getId(), view.getName() );
    }
}
