package com.suncode.plugin.dataviewer.web.advice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.suncode.plugin.dataviewer.configuration.ViewNotExistsException;
import com.suncode.plugin.dataviewer.service.datasupplier.DataSupplierNotExistsException;
import com.suncode.plugin.dataviewer.service.persmission.PermissionException;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.support.ajax.EntityRestResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

@Slf4j
@ControllerAdvice
public class DataControllerAdvice
{
    @ResponseBody
    @ExceptionHandler( PermissionException.class )
    public ResponseEntity<?> handlePermissionException( Exception ex )
    {
        return exceptionResult( ex, HttpStatus.FORBIDDEN );
    }

    @ResponseBody
    @ExceptionHandler( value = ViewNotExistsException.class )
    public ResponseEntity<?> handleViewNotExists( Exception ex )
    {
        return exceptionResult( ex, HttpStatus.NOT_FOUND );
    }

    @ResponseBody
    @ExceptionHandler( value = DataSupplierNotExistsException.class )
    public ResponseEntity<?> handleDataSupplierNotExists( Exception ex )
    {
        return exceptionResult( ex, HttpStatus.NOT_FOUND );
    }

    @ResponseBody
    @ExceptionHandler( value = JsonProcessingException.class )
    public ResponseEntity<?> handleJsonProcessingException( Exception ex )
    {
        return exceptionResult( ex, HttpStatus.BAD_REQUEST );
    }

    private ResponseEntity<?> exceptionResult( Exception ex, HttpStatus status )
    {
        log.error( ex.getMessage(), ex );
        return handleResult( null, ex.getLocalizedMessage(), false, status );
    }

    private ResponseEntity<?> handleResult( CountedResult<Map<String, Object>> data, String message, boolean success,
                                            HttpStatus status )
    {
        EntityRestResult<CountedResult<Map<String, Object>>> result = new EntityRestResult<>();
        result.setSuccess( success );
        result.setMessage( message );
        result.setEntity( data );
        return new ResponseEntity<>( result, status );
    }
}
