package com.suncode.plugin.dataviewer.transfer;

import com.suncode.pwfl.configuration.audit.ConfigurationTransferAudit;
import com.suncode.pwfl.configuration.dto.ConfigurationDtoSystemRoot;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import com.suncode.pwfl.configuration.plugins.PluginConfigurationProvider;
import com.suncode.pwfl.configuration.plugins.mapper.PluginConfigurationPropertiesMapping;
import com.suncode.pwfl.configuration.validators.ConfigurationElementTransferValidatorResult;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service
@RequiredArgsConstructor
public class ConfigurationProvider
    implements PluginConfigurationProvider
{
    private final ConfigurationExporter configurationExporter;

    private final ConfigurationImporter configurationImporter;

    @SneakyThrows
    @Override
    public PluginConfigurationDtoRoot exportConfig()
    {
        return configurationExporter.exportConfig();
    }

    @SneakyThrows
    @Override
    public void importConfig( PluginConfigurationDtoRoot config, ConfigurationTransferAudit importAudit )
    {
        configurationImporter.importConfig( config, importAudit );
    }

    @Override
    public Set<String> importMeAfterPluginsIds( PluginConfigurationDtoRoot config )
    {
        return new HashSet<>();
    }

    @Override
    public List<PluginConfigurationPropertiesMapping> getPropertiesMapping()
    {
        return new ArrayList<>();
    }

    @Override
    public List<ConfigurationElementTransferValidatorResult> validateExportConfig( PluginConfigurationDtoRoot pluginConfig,
                                                                                   ConfigurationDtoSystemRoot systemConfig )
    {
        return new ArrayList<>();
    }

    @Override
    public List<ConfigurationElementTransferValidatorResult> validateImportConfig( PluginConfigurationDtoRoot pluginConfig,
                                                                                   ConfigurationDtoSystemRoot systemConfig )
    {
        return new ArrayList<>();
    }
}
